/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth;

import cn.hutool.core.util.URLUtil;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.fn.builders.operation.Builder;
import org.springdoc.webflux.core.fn.SpringdocRouteBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.endpoint.CustomEndpoint;
import run.halo.app.extension.GroupVersion;
import run.halo.app.extension.ListResult;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.router.QueryParamBuildUtil;
import site.muyin.lywqPluginAuth.query.LywqPluginAuthLogQuery;
import site.muyin.lywqPluginAuth.query.PermanentAuthCodeQuery;
import site.muyin.lywqPluginAuth.query.PermanentAuthUserQuery;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthCode;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthUser;
import site.muyin.lywqPluginAuth.service.LywqPluginAuthService;
import site.muyin.lywqPluginAuth.utils.LywqPluginsUtil;
import site.muyin.lywqPluginAuth.vo.ResultsVO;

@Component
public class LywqPluginAuthEndPoint
implements CustomEndpoint {
    private final LywqPluginsUtil lywqPluginsUtil;
    private final LywqPluginAuthService lywqPluginAuthService;
    private final ReactiveExtensionClient client;
    private final String tag = "lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth";

    @Bean
    RouterFunction<ServerResponse> pluginAuthRoute() {
        return SpringdocRouteBuilder.route().nest(RequestPredicates.path((String)"lywqPluginAuth/public"), this::nestedPublic, builder -> builder.operationId("PluginAuthPublicEndpoints").description("PluginAuth Public Endpoints").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).build();
    }

    public RouterFunction<ServerResponse> endpoint() {
        return SpringdocRouteBuilder.route().nest(RequestPredicates.path((String)"admin"), this::nestedAdmin, builder -> builder.operationId("PluginAuthAdminEndpoints").description("PluginAuth Admin Endpoints").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).nest(RequestPredicates.path((String)"user"), this::nestedUser, builder -> builder.operationId("PluginAuthUserEndpoints").description("PluginAuth User Endpoints").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).nest(RequestPredicates.path((String)"pluginAuth"), this::nestedPluginAuth, builder -> builder.operationId("pluginAuth").description("pluginAuth Endpoints").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).build();
    }

    RouterFunction<ServerResponse> nestedPluginAuth() {
        return SpringdocRouteBuilder.route().GET("/checkVersion", this.lywqPluginsUtil::checkVersionResponse, builder -> builder.operationId("checkVersionResponse").description("\u68c0\u67e5\u63d2\u4ef6\u7248\u672c").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/hasAuth", this.lywqPluginsUtil::hasAuthResponse, builder -> builder.operationId("hasAuthResponse").description("\u662f\u5426\u5b58\u5728\u6388\u6743").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/getAuthUser", this.lywqPluginsUtil::getAuthUserResponse, builder -> builder.operationId("getAuthUserResponse").description("\u83b7\u53d6\u6388\u6743\u7528\u6237").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/authStatus", this.lywqPluginsUtil::authStatusResponse, builder -> builder.operationId("authStatusResponse").description("\u6388\u6743\u72b6\u6001").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/reAuth", this.lywqPluginsUtil::reAuthResponse, builder -> builder.operationId("reAuthResponse").description("\u91cd\u65b0\u6388\u6743").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/doAuth", this.lywqPluginsUtil::doAuthResponse, builder -> builder.operationId("doAuthResponse").description("\u63d0\u4ea4\u6388\u6743").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).GET("/getCurrentDomain", this.lywqPluginsUtil::getCurrentDomainResponse, builder -> builder.operationId("getCurrentDomainResponse").description("\u83b7\u53d6\u5f53\u524d\u57df\u540d").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).build();
    }

    RouterFunction<ServerResponse> nestedPublic() {
        return SpringdocRouteBuilder.route().GET("/checkAuth", this::checkAuth, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/checkUser", this::checkUser, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/authUser", this::authUser, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/auth", this::auth, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/pluginInfo", this::pluginInfo, builder -> {
            builder.operationId("pluginVersion").description("plugin version").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/generateAuthCode", this.lywqPluginAuthService::generateAuthCode, builder -> builder.operationId("generateAuthCode").description("\u751f\u6210\u6388\u6743\u7801").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth")).build();
    }

    private Mono<ServerResponse> createPermanentAuthCode(ServerRequest request) {
        PermanentAuthCodeQuery pendingAuthCodeQuery = new PermanentAuthCodeQuery(request.exchange());
        String pluginKey = pendingAuthCodeQuery.getPluginKey();
        String count = pendingAuthCodeQuery.getCount();
        String channel = pendingAuthCodeQuery.getChannel();
        if (StringUtils.isBlank((CharSequence)pluginKey) || StringUtils.isBlank((CharSequence)channel) || StringUtils.isBlank((CharSequence)count)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.generatePermanentAuthCode(pluginKey, channel, Integer.parseInt(count));
    }

    private Mono<ServerResponse> createPermanentAuthCodeForUser(ServerRequest request) {
        return request.bodyToMono(PermanentAuthCode.class).flatMap(permanentAuthCode -> {
            String pluginKey = permanentAuthCode.getPluginKey();
            String channel = permanentAuthCode.getChannel();
            String authUser = permanentAuthCode.getAuthUser();
            if (StringUtils.isBlank((CharSequence)pluginKey) || StringUtils.isBlank((CharSequence)channel) || StringUtils.isBlank((CharSequence)authUser)) {
                return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
            }
            return this.lywqPluginAuthService.generatePermanentAuthCodeForUser(pluginKey, channel, authUser);
        });
    }

    RouterFunction<ServerResponse> nestedAdmin() {
        return SpringdocRouteBuilder.route().GET("/lywqPluginAuthLogs", this::listLywqPluginAuthLogByLywqPlugin, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/listLywqPluginByHas", this::listLywqPluginByHas, builder -> {
            builder.operationId("listLywqPluginByHas").description("listLywqPluginByHas").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/authUsers", this::authUsers, builder -> {
            builder.operationId("authUsers").description("authUsers by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/lywqPlugins", this::lywqPlugins, builder -> {
            builder.operationId("lywqPlugins").description("lywqPlugins by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/permanentAuthUsers", this::listPermanentAuthUser, builder -> {
            builder.operationId("permanentAuthUsers").description("Lists permanentAuthUser by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, PermanentAuthUserQuery.class);
        }).GET("/permanentAuthCodes", this::listPermanentAuthCode, builder -> {
            builder.operationId("permanentAuthCodes").description("Lists permanentAuthCode by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, PermanentAuthCodeQuery.class);
        }).GET("/createPermanentAuthCode", this::createPermanentAuthCode, builder -> {
            builder.operationId("pluginVersion").description("plugin version").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).POST("/createPermanentAuthCodeForUser", this::createPermanentAuthCodeForUser, builder -> {
            builder.operationId("pluginVersion").description("plugin version").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).build();
    }

    RouterFunction<ServerResponse> nestedUser() {
        return SpringdocRouteBuilder.route().GET("/lywqPluginAuthLogs", this::listLywqPluginAuthLogByUser, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/deleteAuth", this::deleteAuth, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/autoAuth", this::autoAuth, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/lywqPlugins", this::lywqPlugins, builder -> {
            builder.operationId("lywqPlugins").description("lywqPlugins by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/auth", this::authForUser, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).GET("/freeAuthCodeUrl", this::freeAuthCodeUrl, builder -> {
            builder.operationId("listLywqPluginAuthLogs").description("Lists LywqPluginAuthLog by query parameters").tag("lywqPluginAuth.muyin.site/v1alpha1/LywqPluginAuth");
            QueryParamBuildUtil.buildParametersFromType((Builder)builder, LywqPluginAuthLogQuery.class);
        }).build();
    }

    private Mono<ServerResponse> listLywqPluginByHas(ServerRequest request) {
        return this.lywqPluginAuthService.groupBy().collectList().flatMap(lywqPluginVos -> ServerResponse.ok().bodyValue(lywqPluginVos));
    }

    private Mono<ServerResponse> lywqPlugins(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String pluginKey = lywqPluginAuthLogQuery.getPluginKey();
        return this.lywqPluginAuthService.lywqPlugins(pluginKey).distinct().collectList().flatMap(lywqPlugins -> ServerResponse.ok().bodyValue(lywqPlugins));
    }

    private Mono<ServerResponse> authUsers(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String authUser = lywqPluginAuthLogQuery.getAuthUser();
        return this.lywqPluginAuthService.authUsers(authUser).distinct().collectList().flatMap(authUsersVos -> ServerResponse.ok().bodyValue(authUsersVos));
    }

    Mono<ServerResponse> listLywqPluginAuthLogByLywqPlugin(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        return this.listLywqPluginAuthLog(lywqPluginAuthLogQuery).flatMap(lywqPluginAuthLogs -> ServerResponse.ok().bodyValue(lywqPluginAuthLogs));
    }

    private Mono<ListResult<LywqPluginAuthLog>> listLywqPluginAuthLog(LywqPluginAuthLogQuery query) {
        return this.client.list(LywqPluginAuthLog.class, query.toPredicate(), query.toComparator(), query.getPage().intValue(), query.getSize().intValue());
    }

    Mono<ServerResponse> listPermanentAuthUser(ServerRequest request) {
        PermanentAuthUserQuery query = new PermanentAuthUserQuery(request.exchange());
        return this.client.listBy(PermanentAuthUser.class, query.toListOptions(), query.toPageRequest()).flatMap(permanentAuthUsers -> ServerResponse.ok().bodyValue(permanentAuthUsers));
    }

    Mono<ServerResponse> listPermanentAuthCode(ServerRequest request) {
        PermanentAuthCodeQuery query = new PermanentAuthCodeQuery(request.exchange());
        return this.client.listBy(PermanentAuthCode.class, query.toListOptions(), query.toPageRequest()).flatMap(permanentAuthCodes -> ServerResponse.ok().bodyValue(permanentAuthCodes));
    }

    Mono<ServerResponse> listLywqPluginAuthLogByUser(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        return this.getContextUser().flatMap(userName -> {
            lywqPluginAuthLogQuery.currentUser = userName;
            return this.listLywqPluginAuthLog(lywqPluginAuthLogQuery).flatMap(lywqPluginAuthLogs -> ServerResponse.ok().bodyValue(lywqPluginAuthLogs));
        });
    }

    protected Mono<String> getContextUser() {
        return ReactiveSecurityContextHolder.getContext().flatMap(ctx -> {
            String name = ctx.getAuthentication().getName();
            return Mono.just((Object)name);
        });
    }

    private Mono<ServerResponse> deleteAuth(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String name = lywqPluginAuthLogQuery.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return ServerResponse.badRequest().bodyValue((Object)"\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        return this.getContextUser().flatMap(userName -> this.lywqPluginAuthService.deleteAuth(name, (String)userName));
    }

    private Mono<ServerResponse> autoAuth(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String name = lywqPluginAuthLogQuery.getName();
        String authValidationCode = lywqPluginAuthLogQuery.getAuthValidationCode();
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)authValidationCode)) {
            return ServerResponse.badRequest().bodyValue((Object)"\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        return this.lywqPluginAuthService.autoAuth(name, authValidationCode);
    }

    private Mono<ServerResponse> checkAuth(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String pluginKey = lywqPluginAuthLogQuery.getPluginKey();
        String authDomain = lywqPluginAuthLogQuery.getAuthDomain();
        String license = lywqPluginAuthLogQuery.getLicense();
        if (StringUtils.isBlank((CharSequence)pluginKey) || StringUtils.isBlank((CharSequence)authDomain)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.checkAuth(pluginKey, this.urlToDomain(authDomain), license);
    }

    private Mono<ServerResponse> checkUser(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String authUser = lywqPluginAuthLogQuery.getAuthUser();
        if (StringUtils.isBlank((CharSequence)authUser)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.checkUser(authUser);
    }

    private Mono<ServerResponse> authUser(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String authDomain = lywqPluginAuthLogQuery.getAuthDomain();
        if (StringUtils.isBlank((CharSequence)authDomain)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.getAuthUserByDomain(this.urlToDomain(authDomain));
    }

    private Mono<ServerResponse> auth(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String pluginKey = lywqPluginAuthLogQuery.getPluginKey();
        String authDomain = lywqPluginAuthLogQuery.getAuthDomain();
        String authUser = lywqPluginAuthLogQuery.getAuthUser();
        if (StringUtils.isBlank((CharSequence)pluginKey) || StringUtils.isBlank((CharSequence)authDomain) || StringUtils.isBlank((CharSequence)authUser)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.auth(pluginKey, this.urlToDomain(authDomain), authUser);
    }

    private Mono<ServerResponse> authForUser(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String pluginKey = lywqPluginAuthLogQuery.getPluginKey();
        String authDomain = lywqPluginAuthLogQuery.getAuthDomain();
        if (StringUtils.isBlank((CharSequence)pluginKey) || StringUtils.isBlank((CharSequence)authDomain)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.getContextUser().flatMap(userName -> this.lywqPluginAuthService.auth(pluginKey, this.urlToDomain(authDomain), (String)userName));
    }

    private Mono<ServerResponse> freeAuthCodeUrl(ServerRequest request) {
        return this.lywqPluginAuthService.freeAuthCodeUrl();
    }

    private Mono<ServerResponse> pluginInfo(ServerRequest request) {
        LywqPluginAuthLogQuery lywqPluginAuthLogQuery = new LywqPluginAuthLogQuery(request.exchange());
        String pluginKey = lywqPluginAuthLogQuery.getPluginKey();
        if (StringUtils.isBlank((CharSequence)pluginKey)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u8bf7\u6c42\u5f02\u5e38\uff01"));
        }
        return this.lywqPluginAuthService.pluginInfo(pluginKey);
    }

    private String urlToDomain(String url) {
        if (url.contains("http://") || url.contains("https://")) {
            URL urlObj = URLUtil.url(url);
            return urlObj.getAuthority();
        }
        return url;
    }

    public GroupVersion groupVersion() {
        return GroupVersion.parseAPIVersion((String)"lywqPluginAuth.muyin.site/v1alpha1");
    }

    public LywqPluginAuthEndPoint(LywqPluginsUtil lywqPluginsUtil, LywqPluginAuthService lywqPluginAuthService, ReactiveExtensionClient client) {
        this.lywqPluginsUtil = lywqPluginsUtil;
        this.lywqPluginAuthService = lywqPluginAuthService;
        this.client = client;
    }
}

