/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth;

import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import run.halo.app.extension.SchemeManager;
import run.halo.app.extension.index.IndexAttributeFactory;
import run.halo.app.extension.index.IndexSpec;
import run.halo.app.plugin.BasePlugin;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTracker;
import site.muyin.lywqPluginAuth.scheme.LywqPlugin;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthCode;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthUser;
import site.muyin.lywqPluginAuth.utils.LywqPluginsUtil;

@Component
public class LywqPluginAuthStart
extends BasePlugin {
    private static final Logger log = LoggerFactory.getLogger(LywqPluginAuthStart.class);
    private final SchemeManager schemeManager;
    private final LywqPluginsUtil lywqPluginsUtil;

    public LywqPluginAuthStart(PluginWrapper wrapper, SchemeManager schemeManager, LywqPluginsUtil lywqPluginsUtil) {
        super(wrapper);
        this.schemeManager = schemeManager;
        this.lywqPluginsUtil = lywqPluginsUtil;
    }

    public void start() {
        boolean checked = this.lywqPluginsUtil.checkAuth();
        if (!checked) {
            this.lywqPluginsUtil.deleteLicense();
            log.error("\u6388\u6743\u7ba1\u7406\u63d2\u4ef6\u6388\u6743\u5931\u8d25\uff01");
        } else {
            log.info("\u6388\u6743\u7ba1\u7406\u63d2\u4ef6\u6388\u6743\u6210\u529f\uff01");
        }
        this.schemeManager.register(SchedulerEventTracker.class, indexSpecs -> indexSpecs.add(new IndexSpec().setName("name").setIndexFunc(IndexAttributeFactory.simpleAttribute(SchedulerEventTracker.class, SchedulerEventTracker::getName))));
        this.schemeManager.register(LywqPlugin.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("spec.key").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPlugin.class, lywqPlugin -> lywqPlugin.getSpec().getKey())));
            indexSpecs.add(new IndexSpec().setName("spec.name").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPlugin.class, lywqPlugin -> lywqPlugin.getSpec().getName())));
        });
        this.schemeManager.register(LywqPluginAuthLog.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("spec.pluginKey").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPluginAuthLog.class, lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getPluginKey())));
            indexSpecs.add(new IndexSpec().setName("spec.authStatus").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPluginAuthLog.class, lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getAuthStatus())));
            indexSpecs.add(new IndexSpec().setName("spec.authDomain").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPluginAuthLog.class, lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getAuthDomain())));
            indexSpecs.add(new IndexSpec().setName("spec.authUser").setIndexFunc(IndexAttributeFactory.simpleAttribute(LywqPluginAuthLog.class, lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getAuthUser())));
        });
        this.schemeManager.register(PermanentAuthCode.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("code").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getCode)));
            indexSpecs.add(new IndexSpec().setName("pluginKey").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getPluginKey)));
            indexSpecs.add(new IndexSpec().setName("authUser").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getAuthUser)));
            indexSpecs.add(new IndexSpec().setName("authTime").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getAuthTime)));
            indexSpecs.add(new IndexSpec().setName("channel").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getChannel)));
            indexSpecs.add(new IndexSpec().setName("status").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthCode.class, PermanentAuthCode::getStatus)));
        });
        this.schemeManager.register(PermanentAuthUser.class, indexSpecs -> {
            indexSpecs.add(new IndexSpec().setName("authUser").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthUser.class, PermanentAuthUser::getAuthUser)));
            indexSpecs.add(new IndexSpec().setName("pluginKey").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthUser.class, PermanentAuthUser::getPluginKey)));
            indexSpecs.add(new IndexSpec().setName("authTime").setIndexFunc(IndexAttributeFactory.simpleAttribute(PermanentAuthUser.class, PermanentAuthUser::getAuthTime)));
        });
        System.out.println("\u63d2\u4ef6\u542f\u52a8\u6210\u529f\uff01");
    }

    public void stop() {
        this.schemeManager.unregister(this.schemeManager.get(LywqPlugin.class));
        this.schemeManager.unregister(this.schemeManager.get(LywqPluginAuthLog.class));
        this.schemeManager.unregister(this.schemeManager.get(PermanentAuthCode.class));
        this.schemeManager.unregister(this.schemeManager.get(PermanentAuthUser.class));
        this.schemeManager.unregister(this.schemeManager.get(SchedulerEventTracker.class));
        System.out.println("\u63d2\u4ef6\u505c\u6b62\uff01");
    }
}

