/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.filter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import run.halo.app.security.AdditionalWebFilter;
import site.muyin.lywqPluginAuth.config.LywqPluginAuthConfig;
import site.muyin.lywqPluginAuth.utils.PluginCacheManager;

@Component
public class ApiWebFilter
implements AdditionalWebFilter {
    final ServerWebExchangeMatcher requiresMatcher = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/lywqPluginAuth/public/**"});
    private final PluginCacheManager pluginCacheManager;

    public ApiWebFilter(PluginCacheManager pluginCacheManager) {
        this.pluginCacheManager = pluginCacheManager;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.requiresMatcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> {
            LywqPluginAuthConfig config = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
            String apiAccessSecret = config.getApiAccessSecret();
            String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
            if (ObjectUtil.isEmpty(apiAccessSecret)) {
                return this.handleCors(exchange, chain);
            }
            if (ObjectUtil.isEmpty(authorization) || !StrUtil.equals(apiAccessSecret, authorization)) {
                return Mono.error((Throwable)new ServerWebInputException("Authorization failed"));
            }
            return this.handleCors(exchange, chain);
        });
    }

    private Mono<Void> handleCors(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().add("Access-Control-Allow-Origin", "*");
        response.getHeaders().add("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        response.getHeaders().add("Access-Control-Allow-Headers", "Content-Type, Authorization");
        return chain.filter(exchange);
    }

    public int getOrder() {
        return SecurityWebFiltersOrder.AUTHORIZATION.getOrder();
    }
}

