/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.query;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.util.MultiValueMap;
import org.springframework.util.comparator.Comparators;
import org.springframework.web.server.ServerWebExchange;
import run.halo.app.core.extension.endpoint.SortResolver;
import run.halo.app.extension.Extension;
import run.halo.app.extension.router.SortableRequest;
import run.halo.app.extension.router.selector.SelectorUtil;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;

public class LywqPluginAuthLogQuery
extends SortableRequest {
    private final MultiValueMap<String, String> queryParams;
    @Schema(description="Current user")
    public String currentUser;

    public LywqPluginAuthLogQuery(ServerWebExchange exchange) {
        super(exchange);
        this.queryParams = exchange.getRequest().getQueryParams();
    }

    @Schema(description="AuthValidationCode to search lywqPluginAuthLogs under the group")
    public String getAuthValidationCode() {
        return (String)this.queryParams.getFirst((Object)"authValidationCode");
    }

    @Schema(description="Name to search lywqPluginAuthLogs under the group")
    public String getName() {
        return (String)this.queryParams.getFirst((Object)"name");
    }

    @Schema(description="AuthDomain to search lywqPluginAuthLogs under the group")
    public String getAuthDomain() {
        return (String)this.queryParams.getFirst((Object)"authDomain");
    }

    @Schema(description="License to search lywqPluginAuthLogs under the group")
    public String getLicense() {
        return (String)this.queryParams.getFirst((Object)"license");
    }

    @Schema(description="AuthUser to search lywqPluginAuthLogs under the group")
    public String getAuthUser() {
        return (String)this.queryParams.getFirst((Object)"authUser");
    }

    @Schema(description="Keyword to search lywqPluginAuthLogs under the group")
    public String getKeyword() {
        return (String)this.queryParams.getFirst((Object)"keyword");
    }

    @Schema(description="LywqPluginAuthLog group name")
    public String getPluginKey() {
        return (String)this.queryParams.getFirst((Object)"pluginKey");
    }

    @Schema(description="LywqPluginAuthLog group name")
    public String getAuthStatus() {
        return (String)this.queryParams.getFirst((Object)"authStatus");
    }

    @Schema(description="LywqPluginAuthLog group expireTimeType")
    public String getExpireTimeType() {
        return (String)this.queryParams.getFirst((Object)"expireTimeType");
    }

    @ArraySchema(uniqueItems=true, arraySchema=@Schema(name="sort", description="Sort property and direction of the list result. Supported fields: creationTimestamp, priority"), schema=@Schema(description="like field,asc or field,desc", implementation=String.class, example="creationTimestamp,desc"))
    public Sort getSort() {
        return SortResolver.defaultInstance.resolve(this.exchange);
    }

    public Predicate<LywqPluginAuthLog> toPredicate() {
        Predicate<LywqPluginAuthLog> authUserPredicate = lywqPluginAuthLog -> {
            String authUser;
            String string = authUser = StringUtils.isBlank((CharSequence)this.getAuthUser()) ? this.currentUser : this.getAuthUser();
            if (StringUtils.isBlank((CharSequence)authUser)) {
                return true;
            }
            return StringUtils.equals((CharSequence)authUser, (CharSequence)lywqPluginAuthLog.getSpec().getAuthUser());
        };
        Predicate<LywqPluginAuthLog> keywordPredicate = lywqPluginAuthLog -> {
            String keyword = this.getKeyword();
            if (StringUtils.isBlank((CharSequence)keyword)) {
                return true;
            }
            String keywordToSearch = keyword.trim().toLowerCase();
            return StringUtils.containsAnyIgnoreCase((CharSequence)lywqPluginAuthLog.getSpec().getPluginKey(), (CharSequence[])new CharSequence[]{keywordToSearch}) || StringUtils.containsAnyIgnoreCase((CharSequence)lywqPluginAuthLog.getSpec().getAuthDomain(), (CharSequence[])new CharSequence[]{keywordToSearch}) || StringUtils.containsAnyIgnoreCase((CharSequence)lywqPluginAuthLog.getSpec().getAuthUser(), (CharSequence[])new CharSequence[]{keywordToSearch});
        };
        Predicate<LywqPluginAuthLog> pluginKeyPredicate = lywqPluginAuthLog -> {
            String pluginKey = this.getPluginKey();
            if (StringUtils.isBlank((CharSequence)pluginKey)) {
                return true;
            }
            return StringUtils.equals((CharSequence)pluginKey, (CharSequence)lywqPluginAuthLog.getSpec().getPluginKey());
        };
        Predicate<LywqPluginAuthLog> authStatusPredicate = lywqPluginAuthLog -> {
            String authStatus = this.getAuthStatus();
            if (StringUtils.isBlank((CharSequence)authStatus)) {
                return true;
            }
            return StringUtils.equals((CharSequence)authStatus, (CharSequence)lywqPluginAuthLog.getSpec().getAuthStatus());
        };
        Predicate<LywqPluginAuthLog> expireTimePredicate = lywqPluginAuthLog -> {
            String expireTimeType = this.getExpireTimeType();
            if (StringUtils.isBlank((CharSequence)lywqPluginAuthLog.getSpec().getExpireTime()) || StringUtils.isBlank((CharSequence)expireTimeType)) {
                return true;
            }
            DateTime dateTime = DateUtil.parseDateTime(DateUtil.now());
            DateTime expireDate = DateUtil.parse(lywqPluginAuthLog.getSpec().getExpireTime());
            switch (expireTimeType) {
                case "PERMANENT": {
                    return expireDate.year() == 2099;
                }
                case "DEADLINE": {
                    return DateUtil.compare(dateTime, expireDate) < 0 && expireDate.year() != 2099;
                }
                case "EXPIRED": {
                    return DateUtil.compare(dateTime, expireDate) > 0;
                }
            }
            return false;
        };
        Predicate labelAndFieldSelectorToPredicate = SelectorUtil.labelAndFieldSelectorToPredicate((List)this.getLabelSelector(), (List)this.getFieldSelector());
        return pluginKeyPredicate.and(authUserPredicate).and(keywordPredicate).and(authStatusPredicate).and(expireTimePredicate).and(labelAndFieldSelectorToPredicate);
    }

    public Comparator<LywqPluginAuthLog> toComparator() {
        Comparator<LywqPluginAuthLog> comparator;
        Sort sort = this.getSort();
        Sort.Order ctOrder = sort.getOrderFor("creationTimestamp");
        Sort.Order priorityOrder = sort.getOrderFor("priority");
        ArrayList<Comparator<LywqPluginAuthLog>> comparators = new ArrayList<Comparator<LywqPluginAuthLog>>();
        if (ctOrder != null) {
            comparator = Comparator.comparing(lywqPluginAuthLog -> lywqPluginAuthLog.getMetadata().getCreationTimestamp());
            if (ctOrder.isDescending()) {
                comparator = comparator.reversed();
            }
            comparators.add(comparator);
        }
        if (priorityOrder != null) {
            comparator = Comparator.comparing(lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getPriority(), Comparators.nullsLow());
            if (priorityOrder.isDescending()) {
                comparator = comparator.reversed();
            }
            comparators.add(comparator);
        }
        comparators.add(LywqPluginAuthLogQuery.compareCreationTimestamp(false));
        comparators.add(LywqPluginAuthLogQuery.compareName(true));
        return comparators.stream().reduce(Comparator::thenComparing).orElse(null);
    }

    public static <E extends Extension> Comparator<E> compareCreationTimestamp(boolean asc) {
        Comparator<Extension> comparator = Comparator.comparing(e -> e.getMetadata().getCreationTimestamp());
        return asc ? comparator : comparator.reversed();
    }

    public static <E extends Extension> Comparator<E> compareName(boolean asc) {
        Comparator<Extension> comparator = Comparator.comparing(e -> e.getMetadata().getName());
        return asc ? comparator : comparator.reversed();
    }
}

