/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.query;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.PageRequest;
import run.halo.app.extension.PageRequestImpl;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.SortableRequest;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.app.extension.router.selector.SelectorUtil;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthCode;

public class PermanentAuthCodeQuery
extends SortableRequest {
    private final MultiValueMap<String, String> queryParams;

    public PermanentAuthCodeQuery(ServerWebExchange exchange) {
        super(exchange);
        this.queryParams = exchange.getRequest().getQueryParams();
    }

    @Schema(description="Keyword to search PermanentAuthCode under the PermanentAuthCode")
    public String getKeyword() {
        return (String)this.queryParams.getFirst((Object)"keyword");
    }

    @Schema
    public String getPluginKey() {
        return (String)this.queryParams.getFirst((Object)"pluginKey");
    }

    @Schema
    public String getAuthUser() {
        return (String)this.queryParams.getFirst((Object)"authUser");
    }

    @Schema
    public String getStatus() {
        return (String)this.queryParams.getFirst((Object)"status");
    }

    @Schema
    public String getCount() {
        return (String)this.queryParams.getFirst((Object)"count");
    }

    @Schema
    public String getChannel() {
        return (String)this.queryParams.getFirst((Object)"channel");
    }

    public ListOptions toListOptions() {
        String keyword;
        String channel;
        String status;
        String authUser;
        ListOptions listOptions = SelectorUtil.labelAndFieldSelectorToListOptions((List)this.getLabelSelector(), (List)this.getFieldSelector());
        Query query = QueryFactory.all();
        String pluginKey = this.getPluginKey();
        if (StringUtils.isNotBlank((CharSequence)pluginKey)) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.contains((String)"pluginKey", (String)pluginKey));
        }
        if (StringUtils.isNotBlank((CharSequence)(authUser = this.getAuthUser()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.contains((String)"authUser", (String)authUser));
        }
        if (StringUtils.isNotBlank((CharSequence)(status = this.getStatus()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.equal((String)"status", (String)status));
        }
        if (StringUtils.isNotBlank((CharSequence)(channel = this.getChannel()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.equal((String)"channel", (String)channel));
        }
        if (StringUtils.isNotBlank((CharSequence)(keyword = this.getKeyword()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.or((Query)QueryFactory.contains((String)"pluginKey", (String)keyword), (Query)QueryFactory.contains((String)"authUser", (String)keyword), (Query[])new Query[]{QueryFactory.contains((String)"code", (String)keyword), QueryFactory.equal((String)"status", (String)keyword), QueryFactory.equal((String)"channel", (String)keyword)}));
        }
        listOptions.setFieldSelector(FieldSelector.of((Query)query));
        return listOptions;
    }

    public Comparator<PermanentAuthCode> toComparator() {
        Comparator<PermanentAuthCode> comparator;
        ArrayList<Comparator<PermanentAuthCode>> comparators = new ArrayList<Comparator<PermanentAuthCode>>();
        Sort sort = this.getSort();
        Sort.Order ctOrder = sort.getOrderFor("authTime");
        if (ctOrder != null) {
            comparator = Comparator.comparing(PermanentAuthCode::getAuthTime);
            if (ctOrder.isDescending()) {
                comparator = comparator.reversed();
            }
            comparators.add(comparator);
        }
        comparator = Comparator.comparing(PermanentAuthCode::getAuthTime);
        comparators.add(comparator.reversed());
        return comparators.stream().reduce(Comparator::thenComparing).orElse(null);
    }

    public PageRequest toPageRequest() {
        Sort sort = this.getSort();
        if (sort.isUnsorted()) {
            sort = Sort.by((String[])new String[]{"authTime"}).descending();
        }
        return PageRequestImpl.of((int)this.getPage(), (int)this.getSize(), (Sort)sort);
    }
}

