/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.query;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import run.halo.app.extension.ListOptions;
import run.halo.app.extension.PageRequest;
import run.halo.app.extension.PageRequestImpl;
import run.halo.app.extension.index.query.Query;
import run.halo.app.extension.index.query.QueryFactory;
import run.halo.app.extension.router.SortableRequest;
import run.halo.app.extension.router.selector.FieldSelector;
import run.halo.app.extension.router.selector.SelectorUtil;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthUser;

public class PermanentAuthUserQuery
extends SortableRequest {
    private final MultiValueMap<String, String> queryParams;

    public PermanentAuthUserQuery(ServerWebExchange exchange) {
        super(exchange);
        this.queryParams = exchange.getRequest().getQueryParams();
    }

    @Schema(description="Keyword to search PermanentAuthUser under the PermanentAuthUser")
    public String getKeyword() {
        return (String)this.queryParams.getFirst((Object)"keyword");
    }

    @Schema
    public String getPluginKey() {
        return (String)this.queryParams.getFirst((Object)"pluginKey");
    }

    @Schema
    public String getAuthUser() {
        return (String)this.queryParams.getFirst((Object)"authUser");
    }

    public ListOptions toListOptions() {
        String keyword;
        String authUser;
        ListOptions listOptions = SelectorUtil.labelAndFieldSelectorToListOptions((List)this.getLabelSelector(), (List)this.getFieldSelector());
        Query query = QueryFactory.all();
        String pluginKey = this.getPluginKey();
        if (StringUtils.isNotBlank((CharSequence)pluginKey)) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.contains((String)"pluginKey", (String)pluginKey));
        }
        if (StringUtils.isNotBlank((CharSequence)(authUser = this.getAuthUser()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.contains((String)"authUser", (String)authUser));
        }
        if (StringUtils.isNotBlank((CharSequence)(keyword = this.getKeyword()))) {
            query = QueryFactory.and((Query)query, (Query)QueryFactory.or((Query)QueryFactory.contains((String)"pluginKey", (String)keyword), (Query)QueryFactory.contains((String)"authUser", (String)keyword)));
        }
        listOptions.setFieldSelector(FieldSelector.of((Query)query));
        return listOptions;
    }

    public Comparator<PermanentAuthUser> toComparator() {
        Comparator<PermanentAuthUser> comparator;
        ArrayList<Comparator<PermanentAuthUser>> comparators = new ArrayList<Comparator<PermanentAuthUser>>();
        Sort sort = this.getSort();
        Sort.Order ctOrder = sort.getOrderFor("authTime");
        if (ctOrder != null) {
            comparator = Comparator.comparing(PermanentAuthUser::getAuthTime);
            if (ctOrder.isDescending()) {
                comparator = comparator.reversed();
            }
            comparators.add(comparator);
        }
        comparator = Comparator.comparing(PermanentAuthUser::getAuthTime);
        comparators.add(comparator.reversed());
        return comparators.stream().reduce(Comparator::thenComparing).orElse(null);
    }

    public PageRequest toPageRequest() {
        Sort sort = this.getSort();
        if (sort.isUnsorted()) {
            sort = Sort.by((String[])new String[]{"authTime"}).descending();
        }
        return PageRequestImpl.of((int)this.getPage(), (int)this.getSize(), (Sort)sort);
    }
}

