/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.reconcile;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import org.springframework.stereotype.Component;
import run.halo.app.extension.ConfigMap;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import site.muyin.lywqPluginAuth.config.LywqPluginAuthConfig;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTracker;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTrackerService;
import site.muyin.lywqPluginAuth.utils.PluginCacheManager;

@Component
public class SettingToolsReconciler
implements Reconciler<Reconciler.Request> {
    private final ExtensionClient client;
    private final PluginCacheManager pluginCacheManager;
    private final SchedulerEventTrackerService schedulerEventTrackerService;

    public Reconciler.Result reconcile(Reconciler.Request request) {
        String name = request.name();
        if (CharSequenceUtil.equals(name, "lywq-plugin-auth-config")) {
            this.client.fetch(ConfigMap.class, name).ifPresent(configMap -> {
                this.pluginCacheManager.put("lywq-plugin-auth-config", JSONUtil.toJsonStr(configMap.getData()));
                LywqPluginAuthConfig lywqPluginAuthConfig = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
                SchedulerEventTracker schedulerEventTracker = new SchedulerEventTracker();
                schedulerEventTracker.setName("cleanAuthSchedule");
                schedulerEventTracker.setRunEnabled(lywqPluginAuthConfig.getCleanAuthEnable());
                schedulerEventTracker.setCornExpression(lywqPluginAuthConfig.getCornExpression());
                this.schedulerEventTrackerService.addOrUpdate(schedulerEventTracker);
            });
        }
        return new Reconciler.Result(false, null);
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new ConfigMap()).build();
    }

    public SettingToolsReconciler(ExtensionClient client, PluginCacheManager pluginCacheManager, SchedulerEventTrackerService schedulerEventTrackerService) {
        this.client = client;
        this.pluginCacheManager = pluginCacheManager;
        this.schedulerEventTrackerService = schedulerEventTrackerService;
    }
}

