/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.reconcile.schedule;

import cn.hutool.core.util.ObjectUtil;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronExpression;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionOperator;
import run.halo.app.extension.ExtensionUtil;
import run.halo.app.extension.controller.Controller;
import run.halo.app.extension.controller.ControllerBuilder;
import run.halo.app.extension.controller.Reconciler;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTracker;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTrackerService;

public abstract class SchedulerEventTrackerReconciler
implements Reconciler<Reconciler.Request> {
    private static final Logger log = LoggerFactory.getLogger(SchedulerEventTrackerReconciler.class);
    private final SchedulerEventTrackerService schedulerEventTrackerService;
    private Clock clock;
    public static final String TIME_ZONE = "Asia/Shanghai";

    public SchedulerEventTrackerReconciler(SchedulerEventTrackerService schedulerEventTrackerService) {
        this.schedulerEventTrackerService = schedulerEventTrackerService;
        this.clock = Clock.systemDefaultZone();
    }

    protected Reconciler.Result reconcile(String scheduleId, Runnable runnable) {
        SchedulerEventTracker eventTracker = this.schedulerEventTrackerService.getByName(scheduleId);
        if (ObjectUtil.isNotNull((Object)eventTracker)) {
            if (ExtensionUtil.isDeleted((ExtensionOperator)eventTracker) || Boolean.FALSE.equals(eventTracker.getRunEnabled())) {
                return Reconciler.Result.doNotRetry();
            }
            String cron = eventTracker.getCornExpression();
            ZoneId zoneId = ZoneId.systemDefault();
            if (TIME_ZONE != null) {
                try {
                    zoneId = ZoneId.of(TIME_ZONE);
                }
                catch (DateTimeException e) {
                    log.error("Invalid zone ID {}", (Object)TIME_ZONE, (Object)e);
                    return Reconciler.Result.doNotRetry();
                }
            }
            Instant now = Instant.now(this.clock);
            if (!CronExpression.isValidExpression((String)cron)) {
                log.error("Cron expression {} is invalid.", (Object)cron);
                return Reconciler.Result.doNotRetry();
            }
            CronExpression cronExp = CronExpression.parse((String)cron);
            Instant lastScheduledTimestamp = Objects.requireNonNullElseGet(eventTracker.getLastScheduledTimestamp(), () -> eventTracker.getMetadata().getCreationTimestamp());
            ZonedDateTime nextFromNow = (ZonedDateTime)cronExp.next((Temporal)now.atZone(zoneId));
            ZonedDateTime nextFromLast = (ZonedDateTime)cronExp.next((Temporal)lastScheduledTimestamp.atZone(zoneId));
            if (nextFromNow != null && nextFromLast != null && Objects.equals(nextFromNow, nextFromLast)) {
                return new Reconciler.Result(true, Duration.between(now, nextFromNow));
            }
            runnable.run();
            ZonedDateTime zonedNow = now.atZone(zoneId);
            ZonedDateTime scheduleTimestamp = now.atZone(zoneId);
            ZonedDateTime next = lastScheduledTimestamp.atZone(zoneId);
            while (next != null && next.isBefore(zonedNow)) {
                scheduleTimestamp = next;
                next = (ZonedDateTime)cronExp.next((Temporal)next);
            }
            eventTracker.setLastScheduledTimestamp(scheduleTimestamp.toInstant());
            if (next != null) {
                eventTracker.setNextSchedulingTimestamp(next.toInstant());
            }
            this.schedulerEventTrackerService.addOrUpdate(eventTracker);
            return new Reconciler.Result(true, Duration.between(now, next));
        }
        return Reconciler.Result.doNotRetry();
    }

    public Controller setupWith(ControllerBuilder builder) {
        return builder.extension((Extension)new SchedulerEventTracker()).build();
    }
}

