/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.reconcile.schedule;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.stereotype.Service;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ExtensionClient;
import run.halo.app.extension.Metadata;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.Unstructured;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTracker;
import site.muyin.lywqPluginAuth.reconcile.schedule.SchedulerEventTrackerService;

@Service
public class SchedulerEventTrackerServiceImpl
implements SchedulerEventTrackerService {
    private final ExtensionClient client;
    private final ObjectMapper objectMapper = Unstructured.OBJECT_MAPPER;

    @Override
    public SchedulerEventTracker getByName(String name) {
        Predicate<SchedulerEventTracker> predicate = schedulerEventTracker -> schedulerEventTracker.getName().equals(name);
        List schedulerEventTrackers = this.client.list(SchedulerEventTracker.class, predicate, null);
        if (ObjectUtil.isNotEmpty(schedulerEventTrackers)) {
            return (SchedulerEventTracker)((Object)schedulerEventTrackers.get(0));
        }
        return null;
    }

    @Override
    public void addOrUpdate(SchedulerEventTracker schedulerEventTracker) {
        Metadata metadata = new Metadata();
        metadata.setName(schedulerEventTracker.getName());
        metadata.setCreationTimestamp(Instant.now());
        schedulerEventTracker.setMetadata((MetadataOperator)metadata);
        SchedulerEventTracker schedulerEventTrackerOld = this.getByName(schedulerEventTracker.getName());
        if (ObjectUtil.isNotNull((Object)schedulerEventTrackerOld)) {
            schedulerEventTrackerOld.setRunEnabled(schedulerEventTracker.getRunEnabled());
            schedulerEventTrackerOld.setCornExpression(schedulerEventTracker.getCornExpression());
            schedulerEventTrackerOld.setNextSchedulingTimestamp(schedulerEventTracker.getNextSchedulingTimestamp());
            schedulerEventTrackerOld.setLastScheduledTimestamp(schedulerEventTracker.getLastScheduledTimestamp());
            Map extensionMap = (Map)this.objectMapper.convertValue((Object)schedulerEventTrackerOld, Map.class);
            Unstructured extension = new Unstructured(extensionMap);
            this.client.update((Extension)extension);
        } else {
            Map extensionMap = (Map)this.objectMapper.convertValue((Object)schedulerEventTracker, Map.class);
            Unstructured extension = new Unstructured(extensionMap);
            this.client.create((Extension)extension);
        }
    }

    public SchedulerEventTrackerServiceImpl(ExtensionClient client) {
        this.client = client;
    }
}

