/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.service;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.extension.ReactiveExtensionClient;
import run.halo.app.extension.Secret;
import run.halo.app.infra.utils.JsonUtils;

@Component
public class EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    private JavaMailSenderImpl mailSender;
    private final ReactiveExtensionClient client;

    public Mono<Void> sendEmail(String to, String subject, String content) {
        return this.fetchConfig().flatMap(configNode -> {
            JsonNode senderNode = configNode.get("sender");
            if (ObjectUtil.isNull(senderNode)) {
                log.error("\u90ae\u4ef6\u914d\u7f6e\u4e3a\u7a7a\uff01");
                return Mono.empty();
            }
            String host = senderNode.get("host").asText();
            int port = senderNode.get("port").asInt();
            String username = senderNode.get("username").asText();
            String password = senderNode.get("password").asText();
            String formName = senderNode.get("displayName").asText();
            String encryption = senderNode.get("encryption").asText();
            String starttlsEnable = encryption.equals("TLS") ? "true" : "false";
            String sslEnable = encryption.equals("SSL") ? "true" : "false";
            this.mailSender = new JavaMailSenderImpl();
            this.mailSender.setHost(host);
            this.mailSender.setPort(port);
            this.mailSender.setUsername(username);
            this.mailSender.setPassword(password);
            this.mailSender.setProtocol("smtp");
            this.mailSender.setDefaultEncoding("UTF-8");
            Properties properties = new Properties();
            properties.setProperty("mail.form.name", formName);
            properties.setProperty("mail.smtp.auth", "true");
            properties.setProperty("mail.smtp.starttls.enable", starttlsEnable);
            properties.setProperty("mail.smtp.ssl.enable", sslEnable);
            this.mailSender.setJavaMailProperties(properties);
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage);
            try {
                helper.setFrom(username, formName);
                helper.setTo(to);
                helper.setSubject(subject);
                helper.setText(content, true);
                helper.setSentDate(new Date());
                this.mailSender.send(mimeMessage);
                log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
            }
            return Mono.empty();
        });
    }

    public Mono<ObjectNode> fetchConfig() {
        return this.client.fetch(Secret.class, "notifier-setting-secret").mapNotNull(Secret::getStringData).mapNotNull(map -> (String)map.get("default-email-notifier.json")).filter(StringUtils::isNotBlank).map(value -> (ObjectNode)JsonUtils.jsonToObject((String)value, ObjectNode.class)).defaultIfEmpty((Object)JsonNodeFactory.instance.objectNode());
    }

    public EmailService(ReactiveExtensionClient client) {
        this.client = client;
    }
}

