/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.service.impl;

import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import run.halo.app.extension.Extension;
import run.halo.app.extension.ReactiveExtensionClient;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;
import site.muyin.lywqPluginAuth.service.LywqPluginAuthLogService;

@Service
public class LywqPluginAuthLogServiceImpl
implements LywqPluginAuthLogService {
    private final ReactiveExtensionClient reactiveExtensionClient;

    @Override
    public Mono<LywqPluginAuthLog> findByName(String name) {
        return this.reactiveExtensionClient.fetch(LywqPluginAuthLog.class, name);
    }

    @Override
    public Flux<LywqPluginAuthLog> listAll(Predicate<LywqPluginAuthLog> predicate, Comparator<LywqPluginAuthLog> comparator) {
        return this.reactiveExtensionClient.list(LywqPluginAuthLog.class, predicate, comparator);
    }

    @Override
    public Mono<LywqPluginAuthLog> create(LywqPluginAuthLog lywqPluginAuthLog) {
        return this.reactiveExtensionClient.create((Extension)lywqPluginAuthLog);
    }

    @Override
    public Mono<LywqPluginAuthLog> update(LywqPluginAuthLog lywqPluginAuthLog) {
        return this.reactiveExtensionClient.update((Extension)lywqPluginAuthLog);
    }

    @Override
    public Mono<LywqPluginAuthLog> delete(LywqPluginAuthLog lywqPluginAuthLog) {
        return this.reactiveExtensionClient.delete((Extension)lywqPluginAuthLog);
    }

    @Override
    public Mono<Integer> countByPluginKeyAndAuthUser(String pluginKey, String userName) {
        Predicate<LywqPluginAuthLog> authUserPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)userName)) {
                return false;
            }
            return lywqPluginAuthLog.getSpec().getAuthUser().equals(userName);
        };
        Predicate<LywqPluginAuthLog> pluginKeyPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)pluginKey)) {
                return false;
            }
            return lywqPluginAuthLog.getSpec().getPluginKey().equals(pluginKey);
        };
        Predicate<LywqPluginAuthLog> predicate = authUserPredicate.and(pluginKeyPredicate);
        return this.reactiveExtensionClient.list(LywqPluginAuthLog.class, predicate, null).count().map(Long::intValue);
    }

    public LywqPluginAuthLogServiceImpl(ReactiveExtensionClient reactiveExtensionClient) {
        this.reactiveExtensionClient = reactiveExtensionClient;
    }
}

