/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.comparator.Comparators;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import run.halo.app.extension.Metadata;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.infra.ExternalUrlSupplier;
import site.muyin.lywqPluginAuth.config.LywqPluginAuthConfig;
import site.muyin.lywqPluginAuth.scheme.LywqPlugin;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthUser;
import site.muyin.lywqPluginAuth.service.EmailService;
import site.muyin.lywqPluginAuth.service.LywqPluginAuthLogService;
import site.muyin.lywqPluginAuth.service.LywqPluginAuthService;
import site.muyin.lywqPluginAuth.service.LywqPluginService;
import site.muyin.lywqPluginAuth.service.PermanentAuthUserService;
import site.muyin.lywqPluginAuth.service.UserService;
import site.muyin.lywqPluginAuth.utils.PermanentAuthCodeUtil;
import site.muyin.lywqPluginAuth.utils.PluginCacheManager;
import site.muyin.lywqPluginAuth.vo.AuthUsersVO;
import site.muyin.lywqPluginAuth.vo.LywqPluginAuthLogVO;
import site.muyin.lywqPluginAuth.vo.LywqPluginVO;
import site.muyin.lywqPluginAuth.vo.OptionVO;
import site.muyin.lywqPluginAuth.vo.ResultsVO;

@Service
public class LywqPluginAuthServiceImpl
implements LywqPluginAuthService {
    private static final Logger log = LoggerFactory.getLogger(LywqPluginAuthServiceImpl.class);
    private final UserService userService;
    private final LywqPluginService lywqPluginService;
    private final LywqPluginAuthLogService lywqPluginAuthLogService;
    private final PermanentAuthUserService permanentAuthUserService;
    private final EmailService emailService;
    private final ExternalUrlSupplier externalUrl;
    private final PluginCacheManager pluginCacheManager;
    private final PermanentAuthCodeUtil permanentAuthCodeUtil;
    private static final String LYWQ_PLUGIN_AUTH_LOG_GENERATE_NAME = "lywq-plugin-auth-log-";
    private static final String FREE_AMOUNT = "0.0";
    private static final String TEMPORARY_FREE_AMOUNT = "9999";

    public LywqPluginAuthServiceImpl(UserService userService, LywqPluginService lywqPluginService, LywqPluginAuthLogService lywqPluginAuthLogService, PermanentAuthUserService permanentAuthUserService, EmailService emailService, ExternalUrlSupplier externalUrl, PluginCacheManager pluginCacheManager, PermanentAuthCodeUtil permanentAuthCodeUtil) {
        this.userService = userService;
        this.lywqPluginService = lywqPluginService;
        this.lywqPluginAuthLogService = lywqPluginAuthLogService;
        this.permanentAuthUserService = permanentAuthUserService;
        this.emailService = emailService;
        this.externalUrl = externalUrl;
        this.pluginCacheManager = pluginCacheManager;
        this.permanentAuthCodeUtil = permanentAuthCodeUtil;
    }

    @Override
    public Flux<LywqPluginAuthLogVO> listBy(String pluginKey) {
        Predicate<LywqPluginAuthLog> pluginKeyPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)pluginKey)) {
                return true;
            }
            return lywqPluginAuthLog.getSpec().getPluginKey().contains(pluginKey);
        };
        return this.listAll(pluginKeyPredicate).map(LywqPluginAuthLogVO::from);
    }

    @Override
    public Flux<LywqPluginAuthLogVO> listByUser(String userName) {
        Predicate<LywqPluginAuthLog> authUserPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)userName)) {
                return true;
            }
            return lywqPluginAuthLog.getSpec().getAuthUser().contains(userName);
        };
        return this.listAll(authUserPredicate).map(LywqPluginAuthLogVO::from);
    }

    @Override
    public Flux<LywqPluginVO> groupBy() {
        Flux<LywqPluginAuthLog> lywqPluginAuthLogFlux = this.listAll(null);
        return this.listAllLywqPlugin().concatMap(lywqPlugin -> lywqPluginAuthLogFlux.filter(lywqPluginAuthLog -> StringUtils.equals((CharSequence)lywqPluginAuthLog.getSpec().getPluginKey(), (CharSequence)lywqPlugin.getMetadata().getName())).map(LywqPluginAuthLogVO::from).collectList().map(lywqPlugin::withLywqPluginAuthLogs).defaultIfEmpty(lywqPlugin)).mergeWith((Publisher)Mono.defer(() -> this.ungrouped().map(LywqPluginVO::from).flatMap(lywqPlugin -> lywqPluginAuthLogFlux.filter(lywqPluginAuthLog -> StringUtils.isBlank((CharSequence)lywqPluginAuthLog.getSpec().getPluginKey())).map(LywqPluginAuthLogVO::from).collectList().map(lywqPlugin::withLywqPluginAuthLogs).defaultIfEmpty(lywqPlugin))));
    }

    @Override
    public Flux<AuthUsersVO> authUsers(String userName) {
        Flux<LywqPluginAuthLogVO> lywqPluginAuthLogVoFlux = this.listByUser(userName);
        return lywqPluginAuthLogVoFlux.map(lywqPluginAuthLogVO -> AuthUsersVO.builder().displayName(lywqPluginAuthLogVO.getSpec().getAuthUser()).name(lywqPluginAuthLogVO.getSpec().getAuthUser()).build());
    }

    @Override
    public Flux<OptionVO> lywqPlugins(String pluginKey) {
        Flux<LywqPluginVO> lywqPluginVOFlux = this.listAllLywqPlugin();
        return lywqPluginVOFlux.map(lywqPluginVO -> OptionVO.builder().label(lywqPluginVO.getSpec().getName()).value(lywqPluginVO.getSpec().getKey()).build());
    }

    @Override
    public Mono<ServerResponse> deleteAuth(String name, String userName) {
        return this.lywqPluginAuthLogService.findByName(name).flatMap(lywqPluginAuthLog -> {
            if (lywqPluginAuthLog.getSpec().getAuthUser().equals(userName)) {
                return this.lywqPluginAuthLogService.delete((LywqPluginAuthLog)((Object)lywqPluginAuthLog)).then(ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6388\u6743\u8bb0\u5f55\u5220\u9664\u6210\u529f\uff01")));
            }
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8be5\u6388\u6743\u8bb0\u5f55\uff01"));
        }).switchIfEmpty(ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u627e\u5230\u6388\u6743\u4fe1\u606f\uff01")));
    }

    @Override
    public Mono<ServerResponse> autoAuth(String name, String authValidationCode) {
        return this.lywqPluginAuthLogService.findByName(name).flatMap(lywqPluginAuthLog -> this.checkAuthCodeSwitch((LywqPluginAuthLog)((Object)lywqPluginAuthLog), authValidationCode).flatMap(checked -> {
            if (Boolean.FALSE.equals(checked)) {
                return ServerResponse.badRequest().bodyValue((Object)"\u6388\u6743\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
            }
            LywqPluginAuthConfig config = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
            return this.emailService.sendEmail(config.getAdminEmail(), "\u81ea\u52a9\u6388\u6743\u901a\u77e5", this.getMailHtml((LywqPluginAuthLog)((Object)lywqPluginAuthLog))).then(Mono.defer(() -> ServerResponse.ok().bodyValue((Object)"\u6388\u6743\u6210\u529f\uff01")));
        })).switchIfEmpty(ServerResponse.badRequest().bodyValue((Object)"\u672a\u67e5\u8be2\u5230\u6388\u6743\uff01"));
    }

    @Override
    public Mono<ServerResponse> checkUser(String authUser) {
        return this.userService.findByName(authUser).flatMap(user -> ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u7528\u6237\u5b58\u5728\uff01"))).switchIfEmpty(ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u7528\u6237\u4e0d\u5b58\u5728\uff01")));
    }

    @Override
    public Mono<ServerResponse> getAuthUserByDomain(String authDomain) {
        Predicate<LywqPluginAuthLog> authDomainPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)authDomain)) {
                return true;
            }
            return lywqPluginAuthLog.getSpec().getAuthDomain().equals(authDomain);
        };
        Flux<LywqPluginAuthLog> lywqPluginAuthLogFlux = this.lywqPluginAuthLogService.listAll(authDomainPredicate, LywqPluginAuthServiceImpl.defaultComparator());
        return lywqPluginAuthLogFlux.collectList().flatMap(lywqPluginAuthLogs -> {
            if (!lywqPluginAuthLogs.isEmpty()) {
                LywqPluginAuthLog lywqPluginAuthLog = (LywqPluginAuthLog)((Object)((Object)lywqPluginAuthLogs.get(0)));
                return ServerResponse.ok().bodyValue(ResultsVO.success("\u67e5\u8be2\u5230\u6ce8\u518c\u7528\u6237\uff01", lywqPluginAuthLog.getSpec().getAuthUser()));
            }
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u67e5\u8be2\u5230\u6ce8\u518c\u7528\u6237\uff01"));
        });
    }

    @Override
    public Mono<ServerResponse> checkAuth(String pluginKey, String authDomain, String license) {
        Predicate<LywqPluginAuthLog> pluginKeyPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)pluginKey)) {
                return true;
            }
            return lywqPluginAuthLog.getSpec().getPluginKey().contains(pluginKey);
        };
        Predicate<LywqPluginAuthLog> authDomainPredicate = lywqPluginAuthLog -> {
            if (StringUtils.isBlank((CharSequence)authDomain)) {
                return true;
            }
            return lywqPluginAuthLog.getSpec().getAuthDomain().contains(authDomain);
        };
        Predicate<LywqPluginAuthLog> predicate = pluginKeyPredicate.and(authDomainPredicate);
        Flux<LywqPluginAuthLog> lywqPluginAuthLogFlux = this.listAll(predicate);
        if (lywqPluginAuthLogFlux != null) {
            return lywqPluginAuthLogFlux.collectList().flatMap(lywqPluginAuthLogs -> {
                if (!lywqPluginAuthLogs.isEmpty()) {
                    LywqPluginAuthLog lywqPluginAuthLog = (LywqPluginAuthLog)((Object)((Object)lywqPluginAuthLogs.get(0)));
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{license}) && StringUtils.equals((CharSequence)lywqPluginAuthLog.getSpec().getAuthStatus(), (CharSequence)"1")) {
                        if (!StringUtils.equals((CharSequence)lywqPluginAuthLog.getSpec().getLicense(), (CharSequence)license)) {
                            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u63d2\u4ef6\u6388\u6743\u6821\u9a8c\u5931\u8d25\uff01"));
                        }
                        return ServerResponse.ok().bodyValue(ResultsVO.success("\u63d2\u4ef6\u6388\u6743\u6821\u9a8c\u6210\u529f\uff01", lywqPluginAuthLog.getSpec().getLicense()));
                    }
                    if (StringUtils.equals((CharSequence)lywqPluginAuthLog.getSpec().getAuthStatus(), (CharSequence)"1")) {
                        String newLicense = LywqPluginAuthServiceImpl.createLicense(authDomain, pluginKey);
                        lywqPluginAuthLog.getSpec().setLicense(newLicense);
                        return this.lywqPluginAuthLogService.update(lywqPluginAuthLog).flatMap(lywqPluginAuthLogNew -> ServerResponse.ok().bodyValue(ResultsVO.success("\u63d2\u4ef6\u6388\u6743\u6821\u9a8c\u6210\u529f\uff01", lywqPluginAuthLog.getSpec().getLicense())));
                    }
                    return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u3010" + lywqPluginAuthLog.getSpec().getPluginKey() + "\u3011\u63d2\u4ef6\u672a\u6388\u6743\uff01"));
                }
                return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u67e5\u8be2\u5230\u6388\u6743\uff01"));
            });
        }
        return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u67e5\u8be2\u5230\u6388\u6743\uff01"));
    }

    @Override
    public Mono<ServerResponse> auth(String pluginKey, String authDomain, String authUser) {
        LywqPluginAuthConfig config = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
        Integer authCountLimit = config.getAuthCountLimit();
        return this.lywqPluginService.findByKey(pluginKey).flatMap(lywqPlugin -> this.userService.findByName(authUser).flatMap(user -> this.lywqPluginAuthLogService.countByPluginKeyAndAuthUser(pluginKey, authUser).flatMap(count -> {
            if (authCountLimit == -1 || count < authCountLimit) {
                return this.createAuth(pluginKey, authDomain, authUser);
            }
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u60a8\u7684\u6388\u6743\u6570\u91cf\u5df2\u8d85\u9650\uff0c\u8bf7\u5220\u9664\u90e8\u5206\u6388\u6743\u540e\u518d\u8bd5\uff01"));
        })).switchIfEmpty(ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u7528\u6237\u4e0d\u5b58\u5728\uff01")))).switchIfEmpty(Mono.defer(() -> ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u63d2\u4ef6\u4e0d\u5b58\u5728\uff01"))));
    }

    public Mono<ServerResponse> createAuth(String pluginKey, String authDomain, String authUser) {
        LywqPluginAuthLog lywqPluginAuthLog = new LywqPluginAuthLog();
        lywqPluginAuthLog.setMetadata((MetadataOperator)new Metadata());
        lywqPluginAuthLog.getMetadata().setCreationTimestamp(Instant.now());
        lywqPluginAuthLog.getMetadata().setGenerateName(LYWQ_PLUGIN_AUTH_LOG_GENERATE_NAME);
        lywqPluginAuthLog.getMetadata().setName(LYWQ_PLUGIN_AUTH_LOG_GENERATE_NAME + pluginKey + "-" + authDomain + "-" + authUser);
        lywqPluginAuthLog.setSpec(new LywqPluginAuthLog.LywqPluginAuthLogSpec());
        lywqPluginAuthLog.getSpec().setPluginKey(pluginKey);
        lywqPluginAuthLog.getSpec().setAuthDomain(authDomain);
        lywqPluginAuthLog.getSpec().setAuthUser(authUser);
        lywqPluginAuthLog.getSpec().setAuthStatus("0");
        lywqPluginAuthLog.getSpec().setPriority(0);
        return this.checkPermanentAuthorization(pluginKey, authUser).flatMap(isPermanentAuthorization -> {
            if (Boolean.TRUE.equals(isPermanentAuthorization)) {
                lywqPluginAuthLog.getSpec().setAuthStatus("1");
                lywqPluginAuthLog.getSpec().setLicense(LywqPluginAuthServiceImpl.createLicense(authDomain, pluginKey));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                LocalDateTime now = LocalDateTime.now();
                String authTime = now.format(formatter);
                String expireTime = DateUtil.parseLocalDateTime("2099-12-31 00:00:00").format(formatter);
                lywqPluginAuthLog.getSpec().setAuthTime(authTime);
                lywqPluginAuthLog.getSpec().setExpireTime(expireTime);
            }
            return Mono.just((Object)((Object)lywqPluginAuthLog));
        }).flatMap(lywqPluginAuthLogNew -> this.lywqPluginAuthLogService.findByName(lywqPluginAuthLog.getMetadata().getName()).flatMap(lywqPluginAuthLogHas -> ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6388\u6743\u8bb0\u5f55\u5df2\u5b58\u5728\uff01"))).switchIfEmpty(this.lywqPluginAuthLogService.create(lywqPluginAuthLog).flatMap(res -> {
            if (CharSequenceUtil.equals(lywqPluginAuthLog.getSpec().getAuthStatus(), "1")) {
                return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6c38\u4e45\u6388\u6743\u6210\u529f\uff01"));
            }
            return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6388\u6743\u7533\u8bf7\u5df2\u53d1\u9001\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\uff01"));
        })));
    }

    private Mono<Boolean> checkPermanentAuthorization(String pluginKey, String authUser) {
        Predicate<PermanentAuthUser> pluginKeyPredicate = permanentAuthUser -> CharSequenceUtil.equals(pluginKey, permanentAuthUser.getPluginKey());
        Predicate<PermanentAuthUser> authUserPredicate = permanentAuthUser -> CharSequenceUtil.equals(authUser, permanentAuthUser.getAuthUser());
        Predicate<PermanentAuthUser> predicate = pluginKeyPredicate.and(authUserPredicate);
        return this.permanentAuthUserService.listAll(predicate, null).hasElements();
    }

    @Override
    public Mono<ServerResponse> pluginInfo(String pluginKey) {
        return this.lywqPluginService.findByKey(pluginKey).flatMap(lywqPlugin -> {
            LywqPluginVO lywqPluginVo = LywqPluginVO.from(lywqPlugin);
            lywqPluginVo.getSpec().setLywqPluginAuthLogs(null);
            lywqPluginVo.getSpec().setPriority(null);
            return ServerResponse.ok().bodyValue(ResultsVO.success("\u63d2\u4ef6\u4fe1\u606f\u83b7\u53d6\u6210\u529f\uff01", lywqPluginVo.getSpec()));
        }).switchIfEmpty(ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u63d2\u4ef6\u4e0d\u5b58\u5728\uff01")));
    }

    @Override
    @Async
    public void clearExpiredAuth() {
        log.info("\u6267\u884c\u5b9a\u65f6\u6e05\u7406\u6388\u6743\u4efb\u52a1");
        Predicate<LywqPluginAuthLog> authStatusPredicate = lywqPluginAuthLog -> CharSequenceUtil.equals("1", lywqPluginAuthLog.getSpec().getAuthStatus());
        Predicate<LywqPluginAuthLog> expireTimePredicate = lywqPluginAuthLog -> {
            DateTime expireDate;
            if (StringUtils.isBlank((CharSequence)lywqPluginAuthLog.getSpec().getExpireTime())) {
                return true;
            }
            DateTime dateTime = DateUtil.parseDateTime(DateUtil.now());
            return DateUtil.compare(dateTime, expireDate = DateUtil.parse(lywqPluginAuthLog.getSpec().getExpireTime())) > 0;
        };
        Predicate<LywqPluginAuthLog> predicate = authStatusPredicate.and(expireTimePredicate);
        Flux<LywqPluginAuthLog> lywqPluginAuthLogFlux = this.listAll(predicate);
        lywqPluginAuthLogFlux.flatMap(lywqPluginAuthLog -> {
            lywqPluginAuthLog.getSpec().setAuthStatus("0");
            return this.lywqPluginAuthLogService.update((LywqPluginAuthLog)((Object)lywqPluginAuthLog)).flatMap(lywqPluginAuthLogNew -> {
                String authUser = lywqPluginAuthLogNew.getSpec().getAuthUser();
                return this.userService.findByName(authUser).flatMap(user -> this.emailService.sendEmail(user.getSpec().getEmail(), "\u63d2\u4ef6\u6388\u6743\u5df2\u8fc7\u671f", this.getNoticeMailHtml((LywqPluginAuthLog)((Object)((Object)lywqPluginAuthLogNew)))));
            });
        }).subscribe();
    }

    @Override
    public Mono<ServerResponse> generatePermanentAuthCode(String pluginKey, String channel, int count) {
        Flux.range((int)0, (int)count).flatMap(i -> this.permanentAuthCodeUtil.generatePermanentAuthCode(pluginKey, channel, null)).subscribe(result -> System.out.println("Generated permanent auth code for iteration " + (Boolean.TRUE.equals(result) ? "successfully" : "unsuccessfully")), error -> System.err.println("An error occurred while generating permanent auth codes: " + error.getMessage()), () -> System.out.println("Finished generating " + count + " permanent auth codes"));
        return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6c38\u4e45\u6388\u6743\u7801\u751f\u6210\u6210\u529f\uff01"));
    }

    @Override
    public Mono<ServerResponse> generateAuthCode(ServerRequest request) {
        return this.permanentAuthCodeUtil.generateAuthCode().flatMap(authCode -> ServerResponse.ok().bodyValue(ResultsVO.success("\u6388\u6743\u7801\u751f\u6210\u6210\u529f\uff0c\u6709\u6548\u671f\u4e3a5\u5206\u949f\uff01", authCode)));
    }

    @Override
    public Mono<ServerResponse> generatePermanentAuthCodeForUser(String pluginKey, String channel, String userName) {
        return this.permanentAuthCodeUtil.generatePermanentAuthCode(pluginKey, channel, userName).flatMap(result -> {
            if (Boolean.TRUE.equals(result)) {
                return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6c38\u4e45\u6388\u6743\u7801\u751f\u6210\u6210\u529f\uff01"));
            }
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u6c38\u4e45\u6388\u6743\u7801\u751f\u6210\u5931\u8d25\uff01"));
        });
    }

    @Override
    public Mono<ServerResponse> freeAuthCodeUrl() {
        LywqPluginAuthConfig config = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
        String freeAuthCodeUrl = config.getFreeAuthCodeUrl();
        return ServerResponse.ok().bodyValue(ResultsVO.success("\u514d\u8d39\u6388\u6743\u7801\u83b7\u53d6\u5730\u5740\uff01", freeAuthCodeUrl));
    }

    public static String createLicense(String authDomain, String pluginKey) {
        byte[] key = SecureUtil.generateKey(SymmetricAlgorithm.AES.getValue()).getEncoded();
        AES aes = SecureUtil.aes(key);
        String authDomainEncryptedHex = aes.encryptHex(authDomain);
        String pluginKeyEncryptedHex = aes.encryptHex(pluginKey);
        return SecureUtil.pbkdf2(authDomainEncryptedHex.toCharArray(), pluginKeyEncryptedHex.getBytes());
    }

    Mono<LywqPlugin> ungrouped() {
        LywqPlugin lywqPlugin = new LywqPlugin();
        lywqPlugin.setMetadata((MetadataOperator)new Metadata());
        lywqPlugin.getMetadata().setName("ungrouped");
        lywqPlugin.setSpec(new LywqPlugin.LywqPluginSpec());
        lywqPlugin.getSpec().setName("");
        lywqPlugin.getSpec().setPriority(0);
        return Mono.just((Object)((Object)lywqPlugin));
    }

    Flux<LywqPluginAuthLog> listAll(@Nullable Predicate<LywqPluginAuthLog> predicate) {
        return this.lywqPluginAuthLogService.listAll(predicate, LywqPluginAuthServiceImpl.defaultComparator());
    }

    Flux<LywqPluginVO> listAllLywqPlugin() {
        return this.lywqPluginService.listAll(null, LywqPluginAuthServiceImpl.defaultGroupComparator()).map(LywqPluginVO::from);
    }

    static Comparator<LywqPlugin> defaultGroupComparator() {
        Function<LywqPlugin, Integer> priority = lywqPlugin -> lywqPlugin.getSpec().getPriority();
        Function<LywqPlugin, Instant> createTime = lywqPlugin -> lywqPlugin.getMetadata().getCreationTimestamp();
        Function<LywqPlugin, String> name = lywqPlugin -> lywqPlugin.getMetadata().getName();
        return Comparator.comparing(priority, Comparators.nullsLow()).thenComparing(createTime).thenComparing(name);
    }

    static Comparator<LywqPluginAuthLog> defaultComparator() {
        Function<LywqPluginAuthLog, Integer> priority = lywqPluginAuthLog -> lywqPluginAuthLog.getSpec().getPriority();
        Function<LywqPluginAuthLog, Instant> createTime = lywqPluginAuthLog -> lywqPluginAuthLog.getMetadata().getCreationTimestamp();
        Function<LywqPluginAuthLog, String> name = lywqPluginAuthLog -> lywqPluginAuthLog.getMetadata().getName();
        return Comparator.comparing(priority, Comparators.nullsLow()).thenComparing(createTime).thenComparing(name);
    }

    private Mono<Boolean> checkAuthCodeSwitch(LywqPluginAuthLog lywqPluginAuthLog, String authValidationCode) {
        return this.lywqPluginService.findByKey(lywqPluginAuthLog.getSpec().getPluginKey()).flatMap(lywqPlugin -> {
            if (StringUtils.equals((CharSequence)lywqPlugin.getSpec().getPrice(), (CharSequence)FREE_AMOUNT)) {
                return this.permanentAuthCodeUtil.checkAuthCode(lywqPluginAuthLog, authValidationCode);
            }
            if (StringUtils.equals((CharSequence)lywqPlugin.getSpec().getPrice(), (CharSequence)TEMPORARY_FREE_AMOUNT)) {
                return this.permanentAuthCodeUtil.checkTemporaryFreeAuthCodeSwitch(lywqPluginAuthLog, authValidationCode);
            }
            return this.permanentAuthCodeUtil.checkPermanentAuthCode(lywqPluginAuthLog, authValidationCode);
        });
    }

    private String getMailHtml(LywqPluginAuthLog lywqPluginAuthLog) {
        String html = "    <div class=\"container\" style=\"background-color: #ffffff; max-width: 600px; margin: 20px auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);\">\n        <h2 style=\"color: #333333;\">\u6709\u65b0\u7684\u81ea\u52a9\u6388\u6743\u8bb0\u5f55</h2>\n        <h3 style=\"color: #333333;\">\u6388\u6743\u4fe1\u606f\uff1a</h3>\n        <ul style=\"list-style-type: none; padding: 0;\">\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u7528\u6237\uff1a</strong>${authUser}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u57df\u540d\uff1a</strong><a href=\"https://${authDomain}\" target=\"_blank\" style=\"color: #007BFF; text-decoration: underline;\">${authDomain}</a></li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u63d2\u4ef6\uff1a</strong>${pluginKey}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u65f6\u95f4\uff1a</strong>${authTime}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u8fc7\u671f\u65f6\u95f4\uff1a</strong>${expireTime}</li>\n        </ul>\n        <p style=\"line-height: 1.6;\"><a href=\"${jumpUrl}\" target=\"_blank\" style=\"color: #007BFF; text-decoration: underline;\">\u524d\u5f80\u5ba1\u6838</a></p>\n    </div>\n";
        html = html.replace("${authUser}", lywqPluginAuthLog.getSpec().getAuthUser());
        html = html.replace("${authDomain}", lywqPluginAuthLog.getSpec().getAuthDomain());
        html = html.replace("${pluginKey}", lywqPluginAuthLog.getSpec().getPluginKey());
        html = html.replace("${authTime}", lywqPluginAuthLog.getSpec().getAuthTime());
        html = html.replace("${expireTime}", CharSequenceUtil.startWith((CharSequence)lywqPluginAuthLog.getSpec().getExpireTime(), "2099") ? "\u6c38\u4e45\u6388\u6743" : lywqPluginAuthLog.getSpec().getExpireTime());
        html = html.replace("${jumpUrl}", "https://" + this.getCurrentDomain() + "/console/lywqPluginAuth?lywqPlugin=" + lywqPluginAuthLog.getSpec().getPluginKey());
        return html;
    }

    private String getNoticeMailHtml(LywqPluginAuthLog lywqPluginAuthLog) {
        String html = "    <div class=\"container\" style=\"background-color: #ffffff; max-width: 600px; margin: 20px auto; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);\">\n        <h2 style=\"color: #333333;\">\u60a8\u7684\u63d2\u4ef6\u6388\u6743\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\u6388\u6743\uff01</h2>\n        <h3 style=\"color: #333333;\">\u6388\u6743\u4fe1\u606f\uff1a</h3>\n        <ul style=\"list-style-type: none; padding: 0;\">\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u7528\u6237\uff1a</strong>${authUser}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u57df\u540d\uff1a</strong><a href=\"https://${authDomain}\" target=\"_blank\" style=\"color: #007BFF; text-decoration: underline;\">${authDomain}</a></li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u63d2\u4ef6\uff1a</strong>${pluginKey}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u6388\u6743\u65f6\u95f4\uff1a</strong>${authTime}</li>\n            <li style=\"margin-bottom: 10px;\"><strong>\u8fc7\u671f\u65f6\u95f4\uff1a</strong>${expireTime}</li>\n        </ul>\n        <p style=\"line-height: 1.6;\"><a href=\"${jumpUrl}\" target=\"_blank\" style=\"color: #007BFF; text-decoration: underline;\">\u524d\u5f80\u6388\u6743</a></p>\n    </div>\n";
        html = html.replace("${authUser}", lywqPluginAuthLog.getSpec().getAuthUser());
        html = html.replace("${authDomain}", lywqPluginAuthLog.getSpec().getAuthDomain());
        html = html.replace("${pluginKey}", lywqPluginAuthLog.getSpec().getPluginKey());
        html = html.replace("${authTime}", lywqPluginAuthLog.getSpec().getAuthTime());
        html = html.replace("${expireTime}", lywqPluginAuthLog.getSpec().getExpireTime());
        html = html.replace("${jumpUrl}", "https://" + this.getCurrentDomain() + "/console/lywqPluginAuthUser");
        return html;
    }

    private String getCurrentDomain() {
        URL externalUrlRaw = this.externalUrl.getRaw();
        return externalUrlRaw.getAuthority();
    }
}

