/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.utils;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import run.halo.app.infra.ExternalUrlSupplier;
import site.muyin.lywqPluginAuth.vo.ResultsVO;

@Component
public class LywqPluginsUtil {
    private static final Logger log = LoggerFactory.getLogger(LywqPluginsUtil.class);
    private static final String ROOT_PATH = "/.halo2/plugins/lywqPlugins/";
    private static final String LICENSE_PATH = "/license.key";
    public static final String CENTER_URL = "https://blog.muyin.site";
    private static final String referer = "https://www.baidu.com";
    private static final String AUTH_URL = "https://blog.muyin.site/lywqPluginAuth/public/auth";
    private static final String AUTH_USER_URL = "https://blog.muyin.site/lywqPluginAuth/public/authUser";
    private static final String CHECK_USER_URL = "https://blog.muyin.site/lywqPluginAuth/public/checkUser";
    private static final String CHECK_AUTH_URL = "https://blog.muyin.site/lywqPluginAuth/public/checkAuth";
    private static final String PLUGIN_INFO_URL = "https://blog.muyin.site/lywqPluginAuth/public/pluginInfo";
    private static final String PLUGIN_KEY = "lywqPluginAuth";
    private static final String PARAM_FORMAT = "pluginKey=%s&authDomain=%s";
    private static final WebClient WEB_CLIENT = WebClient.builder().defaultHeader("Referer", new String[]{"https://www.baidu.com"}).build();
    private static Path path = Paths.get(System.getProperty("user.home"), "/.halo2/plugins/lywqPlugins/").resolve("lywqPluginAuth/license.key");
    private final ExternalUrlSupplier externalUrl;
    private final PluginWrapper pluginWrapper;
    TimedCache<String, String> timedCache = CacheUtil.newTimedCache(1L * DateUnit.HOUR.getMillis());

    public LywqPluginsUtil(ExternalUrlSupplier externalUrl, PluginWrapper pluginWrapper) {
        this.externalUrl = externalUrl;
        this.pluginWrapper = pluginWrapper;
    }

    public boolean checkAuth() {
        if (this.isOffline()) {
            return true;
        }
        if (this.checkAuthFlag(null)) {
            return true;
        }
        if (this.checkCenter()) {
            return true;
        }
        boolean fileExists = Files.exists(path, new LinkOption[0]);
        try {
            if (!fileExists) {
                String params = String.format(PARAM_FORMAT, PLUGIN_KEY, this.getCurrentDomain());
                ResultsVO resultsVO = this.sendGet(CHECK_AUTH_URL, params);
                return this.handleAuthResponse(resultsVO);
            }
            String licenseContent = new String(Files.readAllBytes(path));
            String params = String.format("pluginKey=%s&authDomain=%s&license=%s", PLUGIN_KEY, this.getCurrentDomain(), licenseContent);
            ResultsVO resultsVO = this.sendGet(CHECK_AUTH_URL, params);
            return this.handleAuthResponse(resultsVO);
        }
        catch (Exception e) {
            log.error("Error during authorization check: " + e.getMessage());
            return this.hasAuth();
        }
    }

    private boolean handleAuthResponse(ResultsVO resultsVO) throws IOException {
        if (ObjectUtils.isEmpty((Object)resultsVO)) {
            log.error("\u8bf7\u6c42\u5931\u8d25\uff01");
            return false;
        }
        if (resultsVO.getCode() == 200) {
            if (!Files.exists(path, new LinkOption[0])) {
                boolean createLicenseFlag = this.createLicense(resultsVO.getData().toString());
                this.checkAuthFlag(createLicenseFlag);
                return createLicenseFlag;
            }
            this.checkAuthFlag(true);
            return true;
        }
        log.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)resultsVO.getCode(), (Object)resultsVO.getMsg());
        this.checkAuthFlag(false);
        return false;
    }

    private boolean createLicense(String license) {
        try {
            Path parentDir = path.getParent();
            Files.createDirectories(parentDir, new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.writeString(path, (CharSequence)license, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deleteLicense() {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getCurrentDomain() {
        URL externalUrlRaw = this.externalUrl.getRaw();
        return externalUrlRaw.getAuthority();
    }

    public boolean hasAuth() {
        if (this.checkCenter()) {
            return true;
        }
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean doAuth(String authUser) {
        if (this.checkCenter()) {
            return true;
        }
        boolean fileExists = Files.exists(path, new LinkOption[0]);
        if (!fileExists) {
            try {
                String params = String.format("pluginKey=%s&authDomain=%s&authUser=%s", PLUGIN_KEY, this.getCurrentDomain(), authUser);
                ResultsVO resultsVO = this.sendGet(AUTH_URL, params);
                if (ObjectUtils.isNotEmpty((Object)resultsVO)) {
                    return resultsVO.getCode() == 200;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean hasUser(String authUser) {
        try {
            String params = String.format("authUser=%s", authUser);
            ResultsVO resultsVO = this.sendGet(CHECK_USER_URL, params);
            if (ObjectUtils.isNotEmpty((Object)resultsVO)) {
                return resultsVO.getCode() == 200;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ResultsVO sendGet(String url, String param) throws Exception {
        try {
            String reqUrl = url + "?" + param;
            HttpRequest request = HttpUtil.createGet(reqUrl);
            request.setConnectionTimeout(3000);
            request.setReadTimeout(3000);
            HttpResponse response = request.execute();
            if (response.isOk()) {
                this.offlineProcessing(false);
                return JSONUtil.toBean(response.body(), ResultsVO.class);
            }
            this.offlineProcessing(true);
            throw new Exception("\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            this.offlineProcessing(true);
            throw e;
        }
    }

    private LywqPluginVO getPluginInfo() {
        try {
            ResultsVO resultsVO = this.sendGet(PLUGIN_INFO_URL, "pluginKey=lywqPluginAuth");
            if (ObjectUtils.isNotEmpty((Object)resultsVO)) {
                if (resultsVO.getCode() == 200) {
                    LywqPluginVO lywqPluginVO = JSONUtil.toBean(resultsVO.getData().toString(), LywqPluginVO.class);
                    return lywqPluginVO;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Mono<ServerResponse> version(ServerRequest serverRequest) {
        LywqPluginVO lywqPluginVO = this.getPluginInfo();
        String localVersion = this.pluginWrapper.getDescriptor().getVersion();
        String lastVersion = ObjectUtil.isNotEmpty(lywqPluginVO) ? lywqPluginVO.getVersion() : localVersion;
        String url = ObjectUtil.isNotEmpty(lywqPluginVO) ? lywqPluginVO.getUrl() : "";
        String label = "\u5f53\u524d\u7248\u672c";
        String version = localVersion;
        String color = "green";
        String shieldsIcon = "https://img.shields.io/badge/%s-V%s-%s?link=%s";
        if (!localVersion.equals(lastVersion)) {
            label = "\u6700\u65b0\u7248\u672c";
            version = lastVersion;
            color = "blue";
        }
        String shieldsIconUrl = String.format(shieldsIcon, label, version, color, url);
        return this.getImageBytes(shieldsIconUrl);
    }

    private Mono<ServerResponse> getImageBytes(String url) {
        return WEB_CLIENT.get().uri(url, new Object[0]).exchange().flatMap(response -> {
            HttpHeaders headers = response.headers().asHttpHeaders();
            String contentType = headers.getContentType().toString();
            return response.bodyToMono(byte[].class).flatMap(imageBytes -> ((ServerResponse.BodyBuilder)ServerResponse.ok().header("content-type", new String[]{contentType})).bodyValue(imageBytes));
        }).retry().timeout(Duration.ofSeconds(5L));
    }

    private boolean checkCenter() {
        String domain = StrUtil.removeAny(CENTER_URL, "http://", "https://");
        return StringUtils.equals((CharSequence)domain, (CharSequence)this.getCurrentDomain());
    }

    private void offlineProcessing(boolean offlineFlag) {
        this.timedCache.put("offline", String.valueOf(offlineFlag), 30L * DateUnit.MINUTE.getMillis());
    }

    private boolean isOffline() {
        String offline = (String)this.timedCache.get("offline", false);
        if (StringUtils.isEmpty((CharSequence)offline)) {
            return false;
        }
        return Boolean.parseBoolean(offline);
    }

    private boolean checkAuthFlag(Boolean checkAuthFlag) {
        if (ObjectUtil.isNull(checkAuthFlag)) {
            String checkAuthFlagStr = (String)this.timedCache.get("checkAuthFlag", false);
            if (StringUtils.isEmpty((CharSequence)checkAuthFlagStr)) {
                return false;
            }
            return Boolean.parseBoolean(checkAuthFlagStr);
        }
        this.timedCache.put("checkAuthFlag", String.valueOf(checkAuthFlag), 30L * DateUnit.SECOND.getMillis());
        return checkAuthFlag;
    }

    public String getAuthUser() {
        try {
            String params = String.format("authDomain=%s", this.getCurrentDomain());
            ResultsVO resultsVO = this.sendGet(AUTH_USER_URL, params);
            if (ObjectUtils.isNotEmpty((Object)resultsVO)) {
                if (resultsVO.getCode() == 200) {
                    return resultsVO.getData().toString();
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Mono<ServerResponse> checkVersionResponse(ServerRequest serverRequest) {
        String lastVersion;
        LywqPluginVO lywqPluginVO = this.getPluginInfo();
        String localVersion = this.pluginWrapper.getDescriptor().getVersion();
        boolean flag = localVersion.equals(lastVersion = ObjectUtil.isNotEmpty(lywqPluginVO) ? lywqPluginVO.getVersion() : localVersion);
        if (flag) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u5f53\u524d\u7248\u672c\u5df2\u662f\u6700\u65b0\u7248\u672c"));
        }
        return ServerResponse.ok().bodyValue(ResultsVO.failure("\u5f53\u524d\u7248\u672c\u4e0d\u662f\u6700\u65b0\u7248\u672c", lywqPluginVO.getUrl()));
    }

    public Mono<ServerResponse> doAuthResponse(ServerRequest request) {
        String authUser = request.queryParam("authUser").orElse("");
        if (StringUtils.isBlank((CharSequence)authUser)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        boolean hasUser = this.hasUser(authUser);
        if (!hasUser) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff01"));
        }
        boolean checked = this.doAuth(authUser);
        if (checked) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u63d0\u4ea4\u6210\u529f\uff01"));
        }
        return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u63d0\u4ea4\u5931\u8d25\uff01"));
    }

    public Mono<ServerResponse> reAuthResponse(ServerRequest request) {
        boolean checked = this.checkAuth();
        if (checked) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6388\u6743\u6210\u529f\uff01"));
        }
        this.deleteLicense();
        return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u6388\u6743\u5931\u8d25\uff01"));
    }

    public Mono<ServerResponse> hasAuthResponse(ServerRequest request) {
        boolean hasAuth = this.hasAuth();
        if (!hasAuth) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u6388\u6743\uff01"));
        }
        return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u5df2\u6388\u6743\uff01"));
    }

    public Mono<ServerResponse> getAuthUserResponse(ServerRequest request) {
        String userName = this.getAuthUser();
        if (StrUtil.isBlank(userName)) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u672a\u67e5\u8be2\u5230\u6ce8\u518c\u7528\u6237\uff01"));
        }
        return ServerResponse.ok().bodyValue(ResultsVO.success("\u67e5\u8be2\u5230\u6ce8\u518c\u7528\u6237\uff01", userName));
    }

    public Mono<ServerResponse> authStatusResponse(ServerRequest request) {
        boolean checked = this.checkAuth();
        if (checked) {
            return ServerResponse.ok().bodyValue((Object)ResultsVO.success("\u6388\u6743\u6210\u529f\uff01"));
        }
        return ServerResponse.ok().bodyValue((Object)ResultsVO.failure("\u6388\u6743\u5931\u8d25\uff01"));
    }

    public Mono<ServerResponse> getCurrentDomainResponse(ServerRequest request) {
        String domain = this.getCurrentDomain();
        return ServerResponse.ok().bodyValue(ResultsVO.success("\u5f53\u524d\u57df\u540d", domain));
    }

    public class LywqPluginVO {
        private String key;
        private String name;
        private String logo;
        private String description;
        private String version;
        private String author;
        private String docs;
        private String url;
        private String price;

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getLogo() {
            return this.logo;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVersion() {
            return this.version;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getDocs() {
            return this.docs;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPrice() {
            return this.price;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLogo(String logo) {
            this.logo = logo;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setDocs(String docs) {
            this.docs = docs;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LywqPluginVO)) {
                return false;
            }
            LywqPluginVO other = (LywqPluginVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$logo = this.getLogo();
            String other$logo = other.getLogo();
            if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$docs = this.getDocs();
            String other$docs = other.getDocs();
            if (this$docs == null ? other$docs != null : !this$docs.equals(other$docs)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$price = this.getPrice();
            String other$price = other.getPrice();
            return !(this$price == null ? other$price != null : !this$price.equals(other$price));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LywqPluginVO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $logo = this.getLogo();
            result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $docs = this.getDocs();
            result = result * 59 + ($docs == null ? 43 : $docs.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : $price.hashCode());
            return result;
        }

        public String toString() {
            return "LywqPluginsUtil.LywqPluginVO(key=" + this.getKey() + ", name=" + this.getName() + ", logo=" + this.getLogo() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", author=" + this.getAuthor() + ", docs=" + this.getDocs() + ", url=" + this.getUrl() + ", price=" + this.getPrice() + ")";
        }
    }
}

