/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.utils;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import run.halo.app.core.extension.User;
import run.halo.app.extension.Metadata;
import run.halo.app.extension.MetadataOperator;
import run.halo.app.extension.ReactiveExtensionClient;
import site.muyin.lywqPluginAuth.config.LywqPluginAuthConfig;
import site.muyin.lywqPluginAuth.scheme.LywqPluginAuthLog;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthCode;
import site.muyin.lywqPluginAuth.scheme.PermanentAuthUser;
import site.muyin.lywqPluginAuth.service.LywqPluginAuthLogService;
import site.muyin.lywqPluginAuth.service.PermanentAuthCodeService;
import site.muyin.lywqPluginAuth.service.PermanentAuthUserService;
import site.muyin.lywqPluginAuth.utils.PluginCacheManager;

@Component
public class PermanentAuthCodeUtil {
    private final PermanentAuthUserService permanentAuthUserService;
    private final PermanentAuthCodeService permanentAuthCodeService;
    private final LywqPluginAuthLogService lywqPluginAuthLogService;
    private final ReactiveExtensionClient reactiveExtensionClient;
    private final PluginCacheManager pluginCacheManager;
    TimedCache<String, String> timedCache = CacheUtil.newTimedCache(1L * DateUnit.MINUTE.getMillis());
    public static final String PERMANENT_AUTH_TIME = "2099-12-31 00:00:00";

    public Mono<String> generateAuthCode() {
        String code = RandomUtil.randomNumbers(8);
        String hasCode = (String)this.timedCache.get(code);
        if (ObjectUtil.isNotEmpty(hasCode)) {
            return this.generateAuthCode();
        }
        this.timedCache.put(code, code, 5L * DateUnit.MINUTE.getMillis());
        return Mono.just((Object)code);
    }

    public String generateRemotePermanentAuthCode() {
        return RandomUtil.randomNumbers(8);
    }

    public Mono<Boolean> generatePermanentAuthCode(String pluginKey, String channel, String userName) {
        String code = RandomUtil.randomStringUpper(12);
        return this.permanentAuthCodeService.findByCode(code).flatMap(permanentAuthCode -> this.generatePermanentAuthCode(pluginKey, channel, userName)).switchIfEmpty(Mono.defer(() -> {
            PermanentAuthCode permanentAuthCode = new PermanentAuthCode();
            permanentAuthCode.setCode(code).setPluginKey(pluginKey).setChannel(channel).setStatus(PermanentAuthCode.Status.PENDING.name());
            if (ObjectUtil.isNotEmpty(userName)) {
                permanentAuthCode.setAuthUser(userName);
            }
            Metadata metadata = new Metadata();
            metadata.setName(code);
            metadata.setCreationTimestamp(Instant.now());
            permanentAuthCode.setMetadata((MetadataOperator)metadata);
            return this.permanentAuthCodeService.create(permanentAuthCode).flatMap(permanentAuthCodeNew -> Mono.just((Object)true));
        }));
    }

    public Mono<Boolean> checkAuthCode(LywqPluginAuthLog lywqPluginAuthLog, String code) {
        String hashCode = (String)this.timedCache.get(code);
        if (ObjectUtil.isNotEmpty(hashCode) && code.equals(hashCode)) {
            this.timedCache.remove(hashCode);
            return this.updateLywqPluginAuthLog(lywqPluginAuthLog, VALIDITY_PERIOD_TYPE.SHORT);
        }
        return Mono.just((Object)false);
    }

    public Mono<Boolean> checkTemporaryFreeAuthCodeSwitch(LywqPluginAuthLog lywqPluginAuthLog, String code) {
        return this.permanentAuthCodeService.findByCode(code).flatMap(permanentAuthCode -> this.checkPermanentAuthCode(lywqPluginAuthLog, code)).switchIfEmpty(this.checkAuthCode(lywqPluginAuthLog, code));
    }

    public Mono<Boolean> checkPermanentAuthCode(LywqPluginAuthLog lywqPluginAuthLog, String code) {
        return this.permanentAuthCodeService.findByCode(code).flatMap(permanentAuthCode -> {
            if (PermanentAuthCode.Status.PENDING.name().equals(permanentAuthCode.getStatus()) && permanentAuthCode.getPluginKey().equals(lywqPluginAuthLog.getSpec().getPluginKey())) {
                return this.getContextUser().flatMap(contextUser -> {
                    String userName = contextUser.getMetadata().getName();
                    if (ObjectUtil.isNotEmpty(permanentAuthCode.getAuthUser()) && !permanentAuthCode.getAuthUser().equals(userName)) {
                        return Mono.just((Object)false);
                    }
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                    LocalDateTime now = LocalDateTime.now();
                    String authTime = now.format(formatter);
                    permanentAuthCode.setAuthUser(userName).setAuthTime(authTime).setStatus(PermanentAuthCode.Status.USED.name());
                    return this.permanentAuthCodeService.update((PermanentAuthCode)((Object)permanentAuthCode)).flatMap(permanentAuthCodeNew -> this.createPermanentAuthUser((PermanentAuthCode)((Object)((Object)((Object)permanentAuthCodeNew))), userName, authTime)).flatMap(res -> this.updateLywqPluginAuthLog(lywqPluginAuthLog, VALIDITY_PERIOD_TYPE.LONG));
                });
            }
            return Mono.just((Object)false);
        }).switchIfEmpty(Mono.just((Object)false));
    }

    private Mono<Boolean> createPermanentAuthUser(PermanentAuthCode permanentAuthCode, String userName, String authTime) {
        PermanentAuthUser permanentAuthUser = new PermanentAuthUser();
        String id = IdUtil.simpleUUID();
        permanentAuthUser.setId(id).setPluginKey(permanentAuthCode.getPluginKey()).setAuthUser(userName).setAuthTime(authTime);
        Metadata metadata = new Metadata();
        metadata.setName(id);
        metadata.setCreationTimestamp(Instant.now());
        permanentAuthUser.setMetadata((MetadataOperator)metadata);
        return this.permanentAuthUserService.create(permanentAuthUser).flatMap(permanentAuthUserNew -> Mono.just((Object)true));
    }

    private Mono<Boolean> updateLywqPluginAuthLog(LywqPluginAuthLog lywqPluginAuthLog, VALIDITY_PERIOD_TYPE type) {
        LywqPluginAuthConfig config = this.pluginCacheManager.getConfig(LywqPluginAuthConfig.class);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
        LocalDateTime now = LocalDateTime.now();
        String authTime = now.format(formatter);
        String expireTime = now.plusDays(config.getAuthDay().intValue()).format(formatter);
        if (VALIDITY_PERIOD_TYPE.LONG == type) {
            expireTime = DateUtil.parseLocalDateTime(PERMANENT_AUTH_TIME).format(formatter);
        }
        lywqPluginAuthLog.getSpec().setAuthTime(authTime);
        lywqPluginAuthLog.getSpec().setExpireTime(expireTime);
        lywqPluginAuthLog.getSpec().setAuthStatus("1");
        return this.lywqPluginAuthLogService.update(lywqPluginAuthLog).flatMap(lywqPluginAuthLogNew -> Mono.just((Object)true));
    }

    protected Mono<User> getContextUser() {
        return ReactiveSecurityContextHolder.getContext().flatMap(ctx -> {
            String name = ctx.getAuthentication().getName();
            return this.reactiveExtensionClient.fetch(User.class, name);
        });
    }

    public PermanentAuthCodeUtil(PermanentAuthUserService permanentAuthUserService, PermanentAuthCodeService permanentAuthCodeService, LywqPluginAuthLogService lywqPluginAuthLogService, ReactiveExtensionClient reactiveExtensionClient, PluginCacheManager pluginCacheManager) {
        this.permanentAuthUserService = permanentAuthUserService;
        this.permanentAuthCodeService = permanentAuthCodeService;
        this.lywqPluginAuthLogService = lywqPluginAuthLogService;
        this.reactiveExtensionClient = reactiveExtensionClient;
        this.pluginCacheManager = pluginCacheManager;
    }

    public static enum VALIDITY_PERIOD_TYPE {
        LONG,
        SHORT;

    }
}

