/*
 * Decompiled with CFR 0.152.
 */
package site.muyin.lywqPluginAuth.utils;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;
import run.halo.app.extension.ConfigMap;
import run.halo.app.extension.ExtensionClient;
import site.muyin.lywqPluginAuth.annotation.GroupName;

@Component
public class PluginCacheManager {
    private final ExtensionClient client;
    private static final Cache<String, String> configCache = CacheUtil.newTimedCache(24L * DateUnit.HOUR.getMillis());

    public void put(String key, String value) {
        configCache.put(key, value);
    }

    public String get(String key) {
        return configCache.get(key);
    }

    public void remove(String key) {
        configCache.remove(key);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        String value = configCache.get(key);
        return this.toObject(value, clazz);
    }

    public <T> T getConfig(Class<T> clazz) {
        String groupName = clazz.getAnnotation(GroupName.class).value();
        if (ObjectUtil.isNull(groupName)) {
            throw new RuntimeException("\u914d\u7f6e\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String configMapStr = this.get("lywq-plugin-auth-config");
        if (ObjectUtil.isNull(configMapStr)) {
            Optional configMapOptional = this.client.fetch(ConfigMap.class, "lywq-plugin-auth-config");
            if (configMapOptional.isPresent()) {
                ConfigMap configMap = (ConfigMap)configMapOptional.get();
                Map configMapData = configMap.getData();
                this.put("lywq-plugin-auth-config", String.valueOf(configMapData));
                return this.getConfig(clazz);
            }
        } else {
            Map configMapData = JSONUtil.toBean(configMapStr, Map.class);
            String groupConfig = (String)configMapData.get(groupName);
            return JSONUtil.toBean(groupConfig, clazz);
        }
        return null;
    }

    public <T> T toObject(String value, Class<T> clazz) {
        if (ObjectUtil.isNotNull(value)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (T)objectMapper.readValue(value, clazz);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public PluginCacheManager(ExtensionClient client) {
        this.client = client;
    }
}

